<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<header class="entry-header">
			<h1 id="header_primary" class="entry-title"> <span><?php the_title(); ?></span> </h1>
			
			<?php if ( has_post_thumbnail() ) : ?>
			<div class="wp-post-image-wrapper">
			<?php the_post_thumbnail(); ?>
			</div>
			<div class="wp-post-image-label"><?php echo get_post(get_post_thumbnail_id())->post_content; ?></div>
			<?php endif; ?>
			
		</header>

		<div class="entry-content">
			<?php the_content(); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'twentytwelve' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		<footer class="entry-meta">
			<?php edit_post_link( __( 'Edit', 'twentytwelve' ), '<span class="edit-link">', '</span>' ); ?>
		</footer><!-- .entry-meta -->
	</article><!-- #post -->
