<?php
/**
 * The template for displaying Category pages
 *
 * Used to display archive-type pages for posts in a category.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

	get_header(); 
	$category = get_the_category();

	if ( $paged >= 2 ) {
		query_posts('posts_per_page=10&cat='.$category[0]->cat_ID.'&paged='.($paged-1) );
	}

?>
	
	<div id="secundary-menu-wrapper">
	<?php 		

		if ( getActiveLanguage() == 'es' ){
			$etapas = array('nursery', 'infantil', 'primaria', 'secundaria', 'bachillerato');
			if ( in_array($category[0]->slug, $etapas) ) {
				wp_nav_menu( array( 'theme_location' => 'menu_etapas_'.$category[0]->slug, 'menu_class' => 'category-menu', 'after' => '') );
			}
			
		}
		else {
			$etapas_en = getEnglishCategories();
			
			if ( isset($etapas_en[$category[0]->slug]) ) {
				wp_nav_menu( array( 'theme_location' => 'menu_etapas_'.$etapas_en[$category[0]->slug], 'menu_class' => 'category-menu', 'after' => '') );
			}
		}
	    
	?>	
	</div>
	
	<section id="primary" class="site-content">
		<div id="content" role="main">

		<?php if ( have_posts() ) : ?>

			<div class="breadcrumbs" xmlns:v="http://rdf.data-vocabulary.org/#">
		    <?php 
		    	if(function_exists('bcn_display')) {
        			bcn_display();
    			}
    			
    			if ( $category[0]->slug != 'revista' ) echo ' > Noticias';
    		?>
			</div>
				
			<h1 id="header_primary" class="entry-title"> <span><?php if ( $category[0]->slug != 'revista' ) echo 'Noticias sobre '; echo single_cat_title( '', false ); ?></span> </h1>
			<?php if ( category_description() ) : // Show an optional category description ?>
			    <div class="archive-meta"><?php echo category_description(); ?></div>
			<?php endif; ?>


			<?php			
			/* Start the Loop */
			while ( have_posts() ) : the_post();

				get_template_part( 'content', get_post_format() );

			endwhile;

			//twentytwelve_content_nav( 'nav-below' );
			?>
			<div class="more_articles">
				<?php echo get_next_posts_link('<img src="'.get_template_directory_uri().'/images/ver_mas_noticias.png" alt="Ver más noticias" />', ($GLOBALS['wp_query']->max_num_pages+1)); ?>
			</div>
			
		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>

		</div><!-- #content -->
	</section><!-- #primary -->

	<div id="secondary_category" class="widget-area" role="complementary">
		<?php wp_nav_menu( array( 'theme_location' => 'menu_etapas_derecha', 'menu_class' => 'category-menu-right', 'after' => '') ); ?>
	</div>
	
<?php get_footer(); ?>

<!-- template: category -->