<?php
	/*
	Plugin Name: Importar HTC
	Description: Herramienta para importar datos desde la antigua web de humanitas
	Version: 1.0
	*/
	
	
	add_action( 'admin_menu', 'my_plugin_menu' );
	
	function my_plugin_menu() {
		add_options_page( 'Importar datos desde HTC', 'Importar HTC', 'manage_options', 'importar-htc', 'load_data_htc' );
	}


	function load_data_htc(){
		
		if ( !current_user_can( 'manage_options' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}
		
		$handle = fopen( plugin_dir_path( __FILE__ )."corto.txt", "r");
	
		$noticias = array();
		$noticia = array();

		$array_meses = array(
			'enero' => 1, 'febrero' => 2, 'marzo' => 3,
			'abril' => 4, 'mayo' => 5, 'junio' => 6,
			'julio' => 7, 'agosto' => 8, 'septiembre' => 9,
			'octubre' => 10, 'noviembre' => 11, 'diciembre' => 12
		);
			
	    while (($line = fgets($handle)) !== false) {
			
			$line = trim($line);
			
			if ( strcmp($line, '####') != 0 ){
				
				if ( !isset($noticia['post_date']) ){
				
					$aux = explode(',', $line);
					$aux = str_replace('de', '', $aux[1]);
					$aux = explode('  ', $aux);
					
					$aux = $aux[2].'-'.$array_meses[ $aux[1] ].'-'.trim($aux[0]);
					
					$noticia['post_date'] = $aux.' 12:00:00';
				}
				else 
				if ( !isset($noticia['post_title']) ){
					$noticia['post_title'] = strip_tags($line);
				}
				else 
				if ( !isset($noticia['post_content']) ){
					$noticia['post_content'] = $line;
				}
				else 
				if ( !isset($noticia['destacado']) ){
					$line = substr( $line, strpos($line, 'img/')+4, strpos($line, 'jpg"') - strpos($line, 'img/') - 1 );
					
					$noticia['destacado'] = $line;
					
				}
				else 
				if ( !isset($noticia['imagenes']) ){
					$line = substr( $line, strpos($line, 'href="')+6, strpos($line, 'html"') - strpos($line, 'href="') - 2 );
					
					$noticia['imagenes'] = $line;
				}
			
			}
			else {
				
				$the_slug = sanitize_title($noticia['post_title']);
			
				$args = array(
					'name'        => $the_slug,
					'post_type'   => 'post',
					'post_status' => 'publish',
					'numberposts' => 1
				);
				$my_posts = get_posts($args);
				
				if ( isset($my_posts[0]->ID) ){
					echo '<p>Noticia ya insertada: '.$noticia['post_title'];
				}
				else {
					$noticia['post_status'] = 'publish';
					
					$gallery = addGallery($noticia);
					
					$noticia['post_content'] = $gallery.$noticia['post_content'];				
					$post_id = wp_insert_post( $noticia );
					
					echo '<p>Insertado post '.$noticia['post_title'].' con ID: '.$post_id;
		
					if ( isset($noticia['destacado']) ){	
						if ( addImage($noticia['destacado'], $post_id) ){
							echo '. Adjunto: OK';
						}
						else {
							echo '. Adjunto: FAIL';
						}
					}
					
					echo '</p>';
					
				}
				
				$noticia = array();	
			}
			
	    }
	
	    fclose($handle);
	    
	}
	
	
	function addImage($line, $post_id){
		
		$filename = ABSPATH.'wp-content/uploads/old_images/'.$line;
		
		// Check the type of file. We'll use this as the 'post_mime_type'.
		$filetype = wp_check_filetype( basename( $filename ), null );
		
		// Get the path to the upload directory.
		$wp_upload_dir = wp_upload_dir();
		
		// Prepare an array of post data for the attachment.
		$attachment = array(
		    'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
		    'post_mime_type' => $filetype['type'],
		    'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
		    'post_content'   => '',
		    'post_status'    => 'inherit'
		);
		
		// Insert the attachment.
		$attach_id = wp_insert_attachment( $attachment, $filename, $post_id );
		
		// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
		require_once( ABSPATH . 'wp-admin/includes/image.php' );
		
		// Generate the metadata for the attachment, and update the database record.
		$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
		wp_update_attachment_metadata( $attach_id, $attach_data );
		
		return set_post_thumbnail( $post_id, $attach_id );

	}
	
	
	function addGallery($noticia){
		
		$gallery  = '';
		if ( isset($noticia['imagenes']) ) {
				
			$filename = ABSPATH.'wp-content/plugins/importar_humanitas/htmls/'.$noticia['imagenes'];
		
			$aux = file_get_contents( $filename );
			
			$aux = substr($aux, strpos($aux, '<p class="titular01">') );
			$aux = substr($aux, 0, strpos($aux, 'InstanceEndEditable') );
			
			//echo $aux;
			
			$dom = new domDocument;
			@$dom->loadHTML($aux);
			
			$dom->preserveWhiteSpace = false;
			$images = $dom->getElementsByTagName('img');
			foreach ($images as $image) {
			
				$url = str_replace('img/', '', $image->getAttribute('src'));
				$url = 'http://humanitastrescantos.com/nueva/wp-content/uploads/old_galeries/'.$url;
				
				$link = '<a href="'.$url.'"><img class="alignnone size-medium" src="'.$url.'" alt="Imagen" /></a> ';
				
				$gallery = $gallery.$link;
				
				//file_put_contents('old_galeries/'.str_replace('img/', '', $image->getAttribute('src')), file_get_contents($url) );
			}
		}
		
		return $gallery;			
	}
	

?>